// ==UserScript==
// @name         5ch 名前欄整形
// @namespace    http://tampermonkey.net/
// @version      2.6
// @description  5ch mailto挿入＋date移動＋Be ID表示＋UIDマージン追加＋date年短縮＋float:rightスパン削除（mailtoリンク無くてもテキスト化＋date移動）
// @author       ChatGPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    const PROCESSED_ATTR = 'data-mailto-processed';
    const BE_PROCESSED_ATTR = 'data-be-processed';
    const UID_PROCESSED_ATTR = 'data-uid-processed';

    function processSpan(span) {
        if (span.hasAttribute(PROCESSED_ATTR)) return;

        const mailtoLinks = Array.from(span.querySelectorAll('a[href^="mailto:"]'));
        const postHeader = span.closest('div.post-header') || span.parentElement;
        const dateSpan = postHeader ? postHeader.querySelector('span.date') : null;

        let mailtoText = null;

        if (mailtoLinks.length > 0) {
            const mailtos = mailtoLinks.map(a => a.getAttribute('href').replace(/^mailto:/, ''));
            mailtoText = mailtos.length >= 2 ? mailtos[1] : mailtos[0];
        } else {
            const text = span.textContent || '';
            const mailRegex = /[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/;
            const found = text.match(mailRegex);
            mailtoText = found ? found[0] : '';
        }

        if (mailtoLinks.length > 0) {
            mailtoLinks.forEach(a => {
                const textNode = document.createTextNode(a.textContent);
                a.replaceWith(textNode);
            });
        }

        const b = document.createElement('b');
        b.textContent = `[${mailtoText}]`;

        if (mailtoLinks.length >= 2) {
            const secondLink = mailtoLinks[1];
            if (secondLink && secondLink.parentNode) {
                secondLink.parentNode.insertBefore(document.createTextNode(' '), secondLink.nextSibling);
                secondLink.parentNode.insertBefore(b, secondLink.nextSibling.nextSibling || null);
                secondLink.parentNode.insertBefore(document.createTextNode(' '), b.nextSibling);
            } else {
                span.appendChild(document.createTextNode(' '));
                span.appendChild(b);
                span.appendChild(document.createTextNode(' '));
            }
        } else {
            span.appendChild(document.createTextNode(' '));
            span.appendChild(b);
            span.appendChild(document.createTextNode(' '));
        }

        if (dateSpan) {
            // date要素をbの隣に移動
            if (b.nextSibling) {
                b.parentNode.insertBefore(dateSpan, b.nextSibling);
            } else {
                b.parentNode.appendChild(dateSpan);
            }

            // 修正：dateの年を短縮
            if (dateSpan.textContent) {
                dateSpan.textContent = dateSpan.textContent.replace(/^20(\d{2})/, '$1');
            }
        }

        span.setAttribute(PROCESSED_ATTR, 'true');
    }

    function processBeSpan(beSpan) {
        if (beSpan.hasAttribute(BE_PROCESSED_ATTR)) return;

        const a = beSpan.querySelector('a[href*="be.5ch.net/user/"]');
        if (a) {
            const match = a.href.match(/\/user\/(\d+)/);
            if (match && match[1]) {
                const userId = match[1];
                const beText = a.textContent;
                if (!beText.includes(`[Be:${userId}]`)) {
                    a.textContent = `[Be:${userId}] ${beText}`;
                }
            }
        }

        beSpan.setAttribute(BE_PROCESSED_ATTR, 'true');
    }

    function processUidSpan(uidSpan) {
        if (uidSpan.hasAttribute(UID_PROCESSED_ATTR)) return;

        // uidSpan.style.marginTop = '4px'; // UID上にマージン追加（調整可）

        uidSpan.setAttribute(UID_PROCESSED_ATTR, 'true');
    }

    // float:right; max-height: 1em; のspanを削除する
    function removeFloatRightSpans() {
        document.querySelectorAll('span[style="float:right; max-height: 1em;"]').forEach(span => {
            span.remove();
        });
    }

    function scanAll() {
        document.querySelectorAll('span.postusername:not([' + PROCESSED_ATTR + '])').forEach(processSpan);
        document.querySelectorAll('span.be.r2BP:not([' + BE_PROCESSED_ATTR + '])').forEach(processBeSpan);
        document.querySelectorAll('span.uid:not([' + UID_PROCESSED_ATTR + '])').forEach(processUidSpan);

        removeFloatRightSpans();
    }

    function init() {
        console.log('5ch mailto＋date移動＋Be表示改善＋UIDマージン＋date年短縮＋float:rightスパン削除 スクリプト起動');
        scanAll();

        const observer = new MutationObserver(mutations => {
            mutations.forEach(mutation => {
                mutation.addedNodes.forEach(node => {
                    if (!(node instanceof Element)) return;

                    if (node.matches && node.matches('span.postusername') && !node.hasAttribute(PROCESSED_ATTR)) {
                        processSpan(node);
                    }
                    if (node.matches && node.matches('span.be.r2BP') && !node.hasAttribute(BE_PROCESSED_ATTR)) {
                        processBeSpan(node);
                    }
                    if (node.matches && node.matches('span.uid') && !node.hasAttribute(UID_PROCESSED_ATTR)) {
                        processUidSpan(node);
                    }

                    node.querySelectorAll && node.querySelectorAll('span.postusername:not([' + PROCESSED_ATTR + '])').forEach(processSpan);
                    node.querySelectorAll && node.querySelectorAll('span.be.r2BP:not([' + BE_PROCESSED_ATTR + '])').forEach(processBeSpan);
                    node.querySelectorAll && node.querySelectorAll('span.uid:not([' + UID_PROCESSED_ATTR + '])').forEach(processUidSpan);

                    // 追加ノード内のfloat:rightスパン削除
                    node.querySelectorAll && node.querySelectorAll('span[style="float:right; max-height: 1em;"]').forEach(s => s.remove());
                });
            });
        });

        observer.observe(document.body, { childList: true, subtree: true });
        setInterval(scanAll, 3000);
    }

    if (document.readyState === 'loading') {
        window.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
